/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.blasting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.init.ModRecipeSerializers;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.BlastFurnaceTileEntity;
import dev.toma.gunsrpg.resource.cooking.IBurningRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BlastingRecipe
implements IRecipe<BlastFurnaceTileEntity>,
IBurningRecipe {
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final ItemStack result;
    private final float experience;
    private final int cookingTime;

    public BlastingRecipe(ResourceLocation id, Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean matches(BlastFurnaceTileEntity tile, World world) {
        return this.ingredient.test(tile.func_70301_a(0));
    }

    public ItemStack assemble(BlastFurnaceTileEntity tile) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Override
    public ItemStack[] getInputStacks() {
        return this.ingredient.func_193365_a();
    }

    public boolean func_192399_d() {
        return true;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    @Override
    public int getCookTime() {
        return this.cookingTime;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.BLASTING_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.BLASTING_RECIPE_TYPE;
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BlastingRecipe> {
        public BlastingRecipe fromJson(ResourceLocation id, JsonObject object) {
            ItemStack itemstack;
            JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)object, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)object, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)object, (String)"ingredient");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
            if (!object.has("result")) {
                throw new JsonSyntaxException("Missing result, expected to find a string or object");
            }
            if (object.get("result").isJsonObject()) {
                itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)object, (String)"result"));
            } else {
                String s1 = JSONUtils.func_151200_h((JsonObject)object, (String)"result");
                ResourceLocation resourcelocation = new ResourceLocation(s1);
                itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_241873_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
            }
            float exp = JSONUtils.func_151221_a((JsonObject)object, (String)"experience", (float)0.0f);
            int time = JSONUtils.func_151208_a((JsonObject)object, (String)"cookingtime", (int)800);
            return new BlastingRecipe(id, ingredient, itemstack, exp, time);
        }

        @Nullable
        public BlastingRecipe fromNetwork(ResourceLocation id, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            float exp = buffer.readFloat();
            int time = buffer.func_150792_a();
            return new BlastingRecipe(id, ingredient, itemstack, exp, time);
        }

        public void toNetwork(PacketBuffer buffer, BlastingRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
            buffer.writeFloat(recipe.experience);
            buffer.func_150787_b(recipe.cookingTime);
        }
    }
}

